/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.ospf;

import ibm.nways.jdm.I18NGiblets;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;
import ibm.nways.jdm.modelgen.TableStatusNamer;
import java.io.Serializable;

public class ActionOspf
implements StatusMapper,
TableStatusNamer {
    private static String enumBundle = "ibm.nways.ospf.eui.EnumeratedResources";
    private static String ospfBundle = "ibm.nways.ospf.Resources";
    private boolean loggingOn = false;

    public ActionOspf() {
        String string = JdmServerImpl.getProperty("startLogging");
        if (string != null && string.equals("yes")) {
            this.loggingOn = true;
        }
    }

    public void calculateStatus(StatusModelInfo statusModelInfo, StatusModelInfo statusModelInfo2) {
        if (this.loggingOn) {
            System.out.println("ActionOspf");
        }
        Serializable[] serializableArray = statusModelInfo.getIndexes();
        String string = serializableArray[0].toString();
        if (this.loggingOn) {
            System.out.println("ifState = " + statusModelInfo.get("Panel.OspfIfState") + string);
        }
        Integer n = (Integer)statusModelInfo.get("Panel.OspfIfState");
        int n2 = n;
        StatusAndExplain statusAndExplain = this.evaluateIfState(n2, string);
        statusModelInfo.setStatusType(statusAndExplain.statType, statusAndExplain.explain, true);
    }

    public I18NString nameThatTableObject(StatusModelInfo statusModelInfo) {
        if (this.loggingOn) {
            System.out.println("ActionOSPF - nameThatTableObject");
        }
        I18NString i18NString = new I18NString(ospfBundle, "STATUS_TABLE_OSPF");
        return i18NString;
    }

    public I18NString nameThatObject(StatusModelInfo statusModelInfo) {
        if (this.loggingOn) {
            System.out.println("ActionOspf - nameThatObject");
        }
        Serializable[] serializableArray = statusModelInfo.getIndexes();
        Object[] objectArray = new Object[]{serializableArray[0].toString()};
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(ospfBundle, "STATUS_NAME", objectArray);
        if (this.loggingOn) {
            System.out.println("name = " + i18NMsgFormat.getTranslation());
        }
        return i18NMsgFormat;
    }

    private StatusAndExplain evaluateIfState(int n, String string) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = new Object[2];
        objectArray[0] = new String(string);
        objectArray2[0] = new I18NMsgFormat(ospfBundle, "ospfstatus", objectArray);
        switch (n) {
            case 1: {
                statusAndExplain.statType = StatusType.CRITICAL;
                objectArray2[1] = new I18NString(enumBundle, "ibm.nways.ospf.model.InterfacesModel.Panel.OspfIfState.down");
                break;
            }
            case 2: {
                statusAndExplain.statType = StatusType.CRITICAL;
                objectArray2[1] = new I18NString(enumBundle, "ibm.nways.ospf.model.InterfacesModel.Panel.OspfIfState.loopback");
                break;
            }
            case 3: {
                statusAndExplain.statType = StatusType.CRITICAL;
                objectArray2[1] = new I18NString(enumBundle, "ibm.nways.ospf.model.InterfacesModel.Panel.OspfIfState.waiting");
                break;
            }
            case 4: {
                statusAndExplain.statType = StatusType.NORMAL;
                objectArray2[1] = new I18NString(enumBundle, "ibm.nways.ospf.model.InterfacesModel.Panel.OspfIfState.pointToPoint");
                break;
            }
            case 5: {
                statusAndExplain.statType = StatusType.NORMAL;
                objectArray2[1] = new I18NString(enumBundle, "ibm.nways.ospf.model.InterfacesModel.Panel.OspfIfState.designatedRouter");
                break;
            }
            case 6: {
                statusAndExplain.statType = StatusType.NORMAL;
                objectArray2[1] = new I18NString(enumBundle, "ibm.nways.ospf.model.InterfacesModel.Panel.OspfIfState.backupDesignatedRouter");
                break;
            }
            case 7: {
                statusAndExplain.statType = StatusType.NORMAL;
                objectArray2[1] = new I18NString(enumBundle, "ibm.nways.ospf.model.InterfacesModel.Panel.OspfIfState.otherDesignatedRouter");
                break;
            }
            default: {
                statusAndExplain.statType = StatusType.UNKNOWN;
                objectArray2[1] = new I18NString(enumBundle, "unknown");
            }
        }
        statusAndExplain.explain = new I18NGiblets(ospfBundle, "statusorder", objectArray2);
        if (this.loggingOn) {
            System.out.println("ret.statType = " + statusAndExplain.statType);
            System.out.println("ret.explain = " + statusAndExplain.explain.getTranslation());
        }
        return statusAndExplain;
    }

    private class StatusAndExplain {
        StatusType statType;
        I18NGiblets explain;

        StatusAndExplain() {
            ActionOspf.this = ActionOspf.this;
        }
    }
}

